<!-- business information here -->
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<!-- <link rel="stylesheet" href="style.css"> -->
	<title>@lang('repair::lang.job_sheet')-({{$job_sheet->job_sheet_no}})</title>
</head>
<body onload="window.print();setTimeout(window.close, 0);" style="border:1px solid #eee;">
<div class="ticket centered">
	@if(!empty($receipt_details->logo))
		<div class="text-box centered">
			<img style="max-height: 100px; width: auto;" src="{{$receipt_details->logo}}" alt="Logo">
		</div>
		<br/>
	@endif
<!-- business information here -->
	@if(!empty($business_name))
		<span class="headings">
						{{$business_name}}
					</span>

		<br/>
	@endif
	@if(!empty($business_mobile))
		{!! $business_mobile !!}
	@endif
	@if(!empty($receipt_details->contact) && !empty($receipt_details->website))
		,
	@endif
	@if(!empty($receipt_details->website))
		{{ $receipt_details->website }}
	@endif
		<hr style="width: 100%"/>
	<div class="text-box">
		<!-- Logo -->
		<p class="centered">
			<!-- Header text -->
			<span class="headings">@lang('repair::lang.job_sheet')-({{$job_sheet->job_sheet_no}})</span>
			<br/>
		</p>
	</div>
	<hr style="width: 100%"/>
	<div class="textbox-info">
		<p class="f-left"><strong>@lang('role.customer')</strong></p>
		<p class="f-right">
			{{$job_sheet->customer->name}}

		</p>
	</div>
	<hr style="width: 100%"/>
	<div class="textbox-info">
		<p class="f-left"><strong>@lang('contact.mobile')</strong></p>
		<p class="f-right">
			{{$job_sheet->customer->mobile}}

		</p>
	</div>
	<hr style="width: 100%"/>
	<div class="textbox-info">
		<p class="f-left"><strong>@lang('receipt.date')</strong></p>
		<p class="f-right">
			{{@format_datetime($job_sheet->created_at)}}
		</p>
	</div>
	<hr style="width: 100%"/>
	<div class="textbox-info">
		<p class="f-left"><strong>@lang('repair::lang.job_sheet_no')</strong></p>
		<p class="f-right">
			{{$job_sheet->job_sheet_no}}
		</p>
	</div>
	<hr style="width: 100%"/>
	@if(!empty($job_sheet->delivery_date))
		<div class="textbox-info">
			<p class="f-left"><strong>@lang('repair::lang.expected_delivery_date')</strong></p>
			<p class="f-right">{{@format_datetime($job_sheet->delivery_date)}}</p>
		</div>
	@endif
	<hr style="width: 100%"/>
	<div class="textbox-info">
		<p class="f-left"><strong>@lang('repair::lang.problem_reported_by_customer')</strong></p>
	</div>

	<div class="textbox-info">
		<p class="f-left">@php
				$defects = json_decode($job_sheet->defects, true);
			@endphp
			@if(!empty($defects))
				@foreach($defects as $product_defect)
					{{$product_defect['value']}}
					@if(!$loop->last)
						{{','}}
					@endif
				@endforeach
			@endif</p>
	</div>
	<hr style="width: 100%"/>
	<div class="textbox-info">
		<p class="f-left"><strong>@lang('repair::lang.condition_of_product')</strong></p>
	</div>
	<div class="textbox-info">
		<p class="f-left">@php
				$product_condition = json_decode($job_sheet->product_condition, true);
			@endphp
			@if(!empty($product_condition))
				@foreach($product_condition as $product_cond)
					{{$product_cond['value']}}
					@if(!$loop->last)
						{{','}}
					@endif
				@endforeach
			@endif</p>
	</div>
	<hr style="width: 100%"/>
	<br />
	<br />
	<div class="textbox-info">
		<b style="padding-left:10px">@lang('product.brand'):</b>
		{{optional($job_sheet->brand)->name}}
		<br>
		<hr style="width: 100%"/>
		<b style="padding-left:10px">@lang('repair::lang.device'):</b>
		{{optional($job_sheet->device)->name}}
		<br>
		<hr style="width: 100%"/>
		<b style="padding-left:10px">@lang('repair::lang.device_model'):</b>
		{{optional($job_sheet->deviceModel)->name}}
		<br>
		<hr style="width: 100%"/>
		<b style="padding-left:10px">@lang('repair::lang.serial_no'):</b>
		{{$job_sheet->serial_no}}
		<br>
		<hr style="width: 100%"/>
		<b style="padding-left:10px">@lang('lang_v1.password'):</b>
		{{$job_sheet->security_pwd}}
		<br>
		<hr style="width: 100%"/>
		<b style="padding-left:10px">
			@lang('repair::lang.security_pattern_code'):
		</b>
		{{$job_sheet->security_pattern}}
		<hr style="width: 100%"/>
	</div>
	<table style="width: 100%">
		<tr>
			<td  style="border: solid 1px;width: 50%">
				<b>
					@lang('sale.invoice_no'):
				</b>
			</td>
			<td  style="border: solid 1px;width: 50%">
				@if($job_sheet->invoices->count() > 0)
					@foreach($job_sheet->invoices as $invoice)
						{{$invoice->invoice_no}}
						@if (!$loop->last)
							{{', '}}
						@endif
					@endforeach
				@endif
			</td>
		</tr>
		<tr>
			<td  style="border: solid 1px;width: 50%">
				<b>
					@lang('repair::lang.estimated_cost'):
				</b>
			</td>
			<td  style="border: solid 1px;width: 50%">
						<span class="display_currency" data-currency_symbol="true">
							{{$job_sheet->estimated_cost}}
						</span>
			</td>
		</tr>
		<tr>
			<td style="border: solid 1px;width: 50%">
				<b>
					@lang('sale.status'):
				</b>
			</td>
			<td  style="border: solid 1px;width: 50%">
				{{optional($job_sheet->status)->name}}
			</td>
		</tr>
		<tr>
			<td  style="border: solid 1px;width: 50%">
				<b>
					@lang('business.location'):
				</b>
			</td>
			<td  style="border: solid 1px;width: 50%">
				{{optional($job_sheet->businessLocation)->name}}
			</td>
		</tr>

		<tr>
			<td  style="border: solid 1px;width: 50%">
				<b>
					@lang('repair::lang.warranty_period'):
				</b>
			</td>
			<td style="border: solid 1px;width: 50%">
				{{$job_sheet->custom_field_2}}
			</td>
		</tr>
		<tr>
			<td style="border: solid 1px;width: 50%">
				<b>
					@lang('repair::lang.custom_payed_amount'):
				</b>
			</td>
			<td  style="border: solid 1px;width: 50%">
				{{$job_sheet->custom_field_3}}
			</td>
		</tr>
	</table>


	{{-- Barcode --}}

	<br/>
	<img class="center-block" src="data:image/png;base64,{{DNS1D::getBarcodePNG($job_sheet->job_sheet_no, 'C128', 2,30,array(39, 48, 54), true)}}">


</div>
<!-- <button id="btnPrint" class="hidden-print">Print</button>
<script src="script.js"></script> -->
</body>
<javascript>

</javascript>

</html>

<style type="text/css">
	.f-8 {
		font-size: 8px !important;
	}
	@media print {
		* {
			font-size: 12px;
			font-family: 'Times New Roman';
			word-break: break-all;
		}
		.f-8 {
			font-size: 8px !important;
		}

		.headings{
			font-size: 16px;
			font-weight: 700;
			text-transform: uppercase;
			white-space: nowrap;
		}

		.sub-headings{
			font-size: 15px !important;
			font-weight: 700 !important;
		}

		.border-top{
			border-top: 1px solid #242424;
		}
		.border-bottom{
			border-bottom: 1px solid #242424;
		}

		.border-bottom-dotted{
			border-bottom: 1px dotted darkgray;
		}

		td.serial_number, th.serial_number{
			width: 5%;
			max-width: 5%;
		}

		td.description,
		th.description {
			width: 35%;
			max-width: 35%;
		}

		td.quantity,
		th.quantity {
			width: 15%;
			max-width: 15%;
			word-break: break-all;
		}
		td.unit_price, th.unit_price{
			width: 25%;
			max-width: 25%;
			word-break: break-all;
		}

		td.price,
		th.price {
			width: 20%;
			max-width: 20%;
			word-break: break-all;
		}

		.centered {
			text-align: center;
			align-content: center;
		}

		.ticket {
			width: 100%;
			max-width: 100%;
		}

		img {
			max-width: inherit;
			width: auto;
		}

		.hidden-print,
		.hidden-print * {
			display: none !important;
		}
	}
	.table-info {
		width: 100%;
	}
	.table-info tr:first-child td, .table-info tr:first-child th {
		padding-top: 8px;
	}
	.table-info th {
		text-align: left;
	}
	.table-info td {
		text-align: right;
	}
	.logo {
		float: left;
		width:35%;
		padding: 10px;
	}

	.text-with-image {
		float: left;
		width:65%;
	}
	.text-box {
		width: 100%;
		height: auto;
	}

	.textbox-info {
		clear: both;
	}
	.textbox-info p {
		margin-bottom: 0px
	}
	.flex-box {
		display: flex;
		width: 100%;
	}
	.flex-box p {
		width: 50%;
		margin-bottom: 0px;
		white-space: nowrap;
	}

	.table-f-12 th, .table-f-12 td {
		font-size: 12px;
		word-break: break-word;
	}

	.bw {
		word-break: break-word;
	}

	.f-right{
		float: right;
		padding-right: 10px;
	}

	.f-left{
		float: left;
		padding-left: 10px;
	}
</style>